unit IWDBExtCtrls32;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.ComponentModel.Design, System.Drawing,
  System.Drawing.Design, System.Data, IWConnectorsCache,
  IWNetClasses, IWNetComponent, AdoNetDb, 
  {$ENDIF}
  {$IFDEF Linux} QGraphics, {$ELSE}Graphics,{$ENDIF}
  {$IFDEF Linux}
    IWJpeg,
  {$ELSE}
    {$IFDEF CLR}
    IWNetJPEG,
    {$ELSE}
    Jpeg,
    {$ENDIF}
  {$ENDIF}
  {$IFNDEF VSNET}
  {$IFDEF Linux}IWCLXClasses,{$ELSE}IWVCLClasses,{$ENDIF}
  {$ENDIF}
  Classes, DB,
  IWExtCtrls32, IWHTMLTag, IWRenderContext, IWBaseInterfaces;

type
  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBImage32.bmp}
  TIWDBImage32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBImage32), 'TIWDBImage32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBImage32 = class(TIWDynamicImage32)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataTable(const ADataTable: System.Data.DataTable);
    function GetDataTable: System.Data.DataTable;
    function ShouldSerializeDataTable: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property DataTable: System.Data.DataTable read GetDataTable write SetDataTable;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBRadioGroup32.bmp}
  TIWDBRadioGroup32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBRadioGroup32), 'TIWDBRadioGroup32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBRadioGroup32 = class(TIWCustomRadioGroup32, IIWInputControl)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    FValues: TIWStringList;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    {$IFDEF VSNET}
    procedure SetDataTable(const ADataTable: System.Data.DataTable);
    function GetDataTable: System.Data.DataTable;
    function ShouldSerializeDataTable: Boolean;
    {$ENDIF}
    procedure SetValues(const AValue: TIWStringList);
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property DataTable: System.Data.DataTable read GetDataTable write SetDataTable;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property Values: TIWStringList read FValues write SetValues;
    property Items;
  end;

implementation

uses
  IWDBCommon, IWControl, SysUtils;

{ TIWDBImage32 }

{$IFDEF VSNET}
procedure TIWDBImage32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBImage32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited;
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

procedure TIWDBImage32.InitControl; 
begin
  inherited;
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBImage32.SetDataTable(const ADataTable: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(ADataTable);
end;

function TIWDBImage32.ShouldSerializeDataTable: Boolean;
begin
  result := Assigned(DataTable);
end;

function TIWDBImage32.GetDataTable: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBImage32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited;
end;

function TIWDBImage32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  S: TMemoryStream;
  Ljpg: TJPEGImage;
  LHeader: array [0..1] of byte;
begin
  // Clear first in case the datafield is empty so we dont display the last image
  FPicture.Graphic := nil;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsBlob then begin
      S := TMemoryStream.Create;
      try
        TBlobField(LField).SaveToStream(S);
        // Find file type
        S.Position := 0;
        S.Read(LHeader, 2);
        S.Position := 0;
        if (LHeader[0] = $FF) and (LHeader[1] = $D8) then begin
          LJPg := TJPEGImage.Create;
          try
            LJpg.LoadFromStream(S);
            FPicture.Assign(LJPG);
          finally
            FreeAndNil(LJpg);
          end;
        end else begin
          FPicture.Assign(LField);
        end;
      finally
        FreeAndNil(S);
      end;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

{ TIWDBRadioGroup32 }

procedure TIWDBRadioGroup32.InitControl; 
begin
  inherited;
  FValues := TIWStringList.Create;
  FDataField := '';
end;

destructor TIWDBRadioGroup32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FValues);
  inherited Destroy;
end;

{$IFDEF VSNET}
procedure TIWDBRadioGroup32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBRadioGroup32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited;
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBRadioGroup32.SetDataTable(const ADataTable: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(ADataTable);
end;

function TIWDBRadioGroup32.ShouldSerializeDataTable: Boolean;
begin
  result := Assigned(DataTable);
end;

function TIWDBRadioGroup32.GetDataTable: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBRadioGroup32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
     FItemIndex := FValues.IndexOf(GetFieldText(LField));
     if FItemIndex<0 then
        FItemIndex := FItems.IndexOf(GetFieldText(LField));
  end else begin
    FItemIndex := -1;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBRadioGroup32.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex > -1 then begin
      with FItems do begin
        if FValues.Count > FItemIndex then begin
          s := FValues[FItemIndex]
        end else begin
          s := FItems[FItemIndex]
        end;
      end;
    end else begin
      s := '';
    end;
    if (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

procedure TIWDBRadioGroup32.SetValues(const AValue: TIWStringList);
begin
  FValues.Assign(AValue);
end;

end.
